--do return Def.ActorFrame{} end;

if not getenv('nextChapter') then
	setenv("nextChapter","char0");
end;

local ch;
if THEME:GetCurLanguage() == 'es' then
	ch = ResolveRelativePath('es/'..getenv("nextChapter")..".lua",1)
else
	ch = ResolveRelativePath(getenv("nextChapter")..".lua",1)
end;
assert(ch,getenv("nextChapter").." does not point to a valid map.");
Trace("Loading chapter "..ch)
local chapterData,e = loadfile(ch);
assert(chapterData,e);
chapterData = chapterData(...);
assert(#chapterData > 0)

--the current part needs to be known in advance so portraits can be loaded in advance..
local curPart = tonumber(getenv('nextPart'));
Trace("Starting from part "..curPart)
assert(chapterData[curPart],'curPart higher than number of parts... '..curPart)

if not STORYDATA.data then
	Warn("There is no savedata. Commands that use flags will not work.");
end;

--Load backgrouds
local vnBackgrounds;
if chapterData[curPart].LoadBackgrounds ~= nil then
	vnBackgrounds = VNBackgrounds(chapterData[curPart].LoadBackgrounds);
end;

--Load portraits
local p = {};
if chapterData[curPart].LoadImages then --It's okay if there aren't any images to load.
	for _,s in ipairs(chapterData[curPart].LoadImages) do
		p[s] = VNTextPortrait2(s)
	end;
end;

--Load sounds
--Since VNUtils does not have access to chapterData this has to be here
local function swrap()
	local sound_wrapper = {
		__index = {
			make_actor=function(self)
				return Def.ActorFrame{
					OnCommand=function(subself)
						self.frame=subself
					end;
				};
			end;
		};
	};
	return setmetatable({}, sound_wrapper)
end;
local sound_wrapper = swrap();
local s = sound_wrapper:make_actor();

if chapterData[curPart].LoadMusic then
	for i,sound in ipairs(chapterData[curPart].LoadMusic) do
		s[#s+1] = Def.Sound{
			Name=sound; --God help you if you have a stupid name for your audio
			File=THEME:GetPathS('',sound);
		};
		if i == 1 and chapterData[curPart].autoPlayMusic then
			s[#s]['OnCommand']=function(sub)
				sub:play();
			end;
		end;
	end;
	assert(#s>0,"You have a PlayMusic table in the chapter data, but you didn't put in any songs.");
end;

local vntext = LoadVNText4(STORYDATA.data,p,sound_wrapper,vnBackgrounds);
local vntextFrame;
local cursorFrame;
local is_options_open=false

local function goToNextPart()
	if curPart+1 > #chapterData then
		local cN = STORYDATA:GetChapterNumber(getenv('nextChapter'))
		if cN ~= 0 and cN < #CHAPTER_ORDER then
			setenv('nextChapter',CHAPTER_ORDER[cN+1]);
			setenv('nextPart',1);
		else
			SCREENMAN:SystemMessage("Next chapter not found. Maybe hit the end of the VN?");
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenCredits");
		end;
	else
		setenv('nextPart',curPart+1);
		--I already checked if it was over the limit above so there HAS to be something next and accessing it is fine
		if chapterData[curPart+1]['FreeTime'] then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusicFreePlay")
		end
		--elseif chapterData[curPart]['SongAtEnd'] then
	end;
	SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
end;

local function dialogueInputHandler(event)
	
	if is_options_open then return end;
	
	local pn= event.PlayerNumber
	local button = event.button
	-- If the PlayerNumber isn't set, the button isn't mapped.  Ignore it.
	-- ...Unless it's the mouse.
	
	if not pn and event.DeviceInput.is_mouse == false then return end
	if event.type == "InputEventType_Release" then return end
	
	if event.DeviceInput.is_mouse then
		button = ToEnumShortString(event.DeviceInput.button)
	end
	
	--SCREENMAN:SystemMessage("aaa");

	if ChoiceTable ~= nil and not ChoiceTable.Finished then
		--assert(ChoiceTable,"ChoiceTable hasn't been set. Can't pick a choice when you haven't set the choices yet!");
		if button == "MenuUp" then
			if ChoiceTable.Result > 1 then
				ChoiceTable.Result = ChoiceTable.Result-1;
				cursorFrame:playcommand("Update");
				return;
			end;
		elseif button == "MenuDown" then
			if ChoiceTable.Result < #ChoiceTable.Choices then
				ChoiceTable.Result = ChoiceTable.Result+1;
				cursorFrame:playcommand("Update");
				return;
			end;
		--[[elseif button == "left mouse button" or button == "Start" or button == "Center" then
			pickingChoice = false;
			cursorFrame:playcommand("Hide");]]
		end;
	end;
	if button == "left mouse button" or button == "Start" or button == "Center" then
		if not vntext:is_finished() then
			--SCREENMAN:SystemMessage("skip");
			vntext:skip();
		else
			if ChoiceTable and not ChoiceTable.Finished then
				ChoiceTable.Finished=true;
				cursorFrame:playcommand("Hide");
			end;
			--[[
			vntext:advance() will set the new text. 
			If it returns false we either hit the end or it encountered an 'exit' opcode
			]]
			if vntext:no_more_text() or vntext:advance() == false then
				goToNextPart()
			end;
		end;
	elseif button == "Select" then
		SCREENMAN:SystemMessage(boolToString(vntext:no_more_text()).." "..vntext.curIndex.." "..#vntext.msgTable)
	elseif button == "Back" or button == "right mouse button" then
	
		SCREENMAN:GetTopScreen():SetPrevScreenName("ScreenTitleMenu");
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
		return true;
		--Should have an overlay menu instead...
		--SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
		--SCREENMAN:AddNewScreenToTop("ScreenStoryOptions");
		--is_options_open=true
		--MESSAGEMAN:Broadcast("OptionsScreenOn");
		--return true; --Don't forget this! You need to return true to tell SCREENMAN that the input has been handled and that the options input handler shouldn't handle it!
	else
		SCREENMAN:SystemMessage("unknown button: "..button);
	end;
end;


--Spawn actors
local t = Def.ActorFrame{
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(dialogueInputHandler);
		--SCREENMAN:GetTopScreen():AddInputCallback(dialogueInputHandler);
	end;
	
	LoadFont("Common Normal")..{
		InitCommand=cmd(horizalign,left;vertalign,top;xy,10,10);
		Text=getenv('nextChapter').." "..curPart;
		Condition=DoDebug;
	}
};


--Add sounds
t[#t+1]=s;

--This should probably be a metatable
--[[t[#t+1] = Def.ActorFrame{
	Name="EventBGFrame";
	InitCommand=cmd(diffusealpha,1;); --Draw last
	OnCommand=function(self)
		bgFrame = self;
	end;
	PlayCommand=cmd(stoptweening;linear,.3;diffusealpha,1);
	StopCommand=cmd(stoptweening;linear,.3;diffusealpha,0);
	
	Def.Sprite{
		Name="EventBG1";
		Condition=chapterData[curPart].LoadBackgrounds ~= nil;
		Texture=(chapterData[curPart].LoadBackgrounds and THEME:GetPathB("StoryArea","overlay/"..chapterData[curPart].LoadBackgrounds[1]) or "eventBG");
		InitCommand=cmd(Cover;z,502);
		bgDiffuseMessageCommand=function(self,params)
			self:linear(.3):diffuse(color(params[1]))
		end;
	};
	Def.Sprite{
		Name="EventBG2";
		InitCommand=cmd(diffusealpha,0;z,501);
	};
}]]

if vnBackgrounds then
	t[#t+1]=vnBackgrounds:makeActorFrame()
end;

--Add portrait actors
local pA = Def.ActorFrame{ InitCommand=cmd(SetDrawByZPosition,true;y,SCREEN_CENTER_Y+100); };
for i,pp in pairs(p) do
	pA[#pA+1] = pp:make_actor(); --Since we have a handle on the actor with a metatable there's no reason to keep it in its own ActorFrame... Right now, anyways.
end;
t[#t+1]=pA

--This holds the dialogue text.
t[#t+1] = Def.ActorFrame{
	InitCommand=cmd(y,SCREEN_CENTER_Y+165;visible,true);
	StopCommand=function(self)
		--self:visible(false);
	end;
	
	OnCommand=function(self)
		vntextFrame = self;
		local ctx = getenv('ctx');
		
		if ctx then
			Trace("Resuming context!")
			--vntext:set_new_table(npc.msg,saveData[mapData.name][npcID])
			vntext:set_new_table(ctx.msgTable,ctx.selfSwitches,ctx.curIndex)
			setenv('ctx',nil)
		elseif curPart then
			vntext:set_new_table(chapterData[curPart].msg);
		else
			vntext:set_new_table(chapterData[1].msg);
		end;
	end;
	
	FreezeContextMessageCommand=function(self)
		Trace("freezing context!");
		inputLevel=INPUT_LOCKED
		local vntextCtx = vntext:get_context();
		setenv("ctx",{msgTable = vntextCtx[1], curIndex = vntextCtx[2],  selfSwitches = vntextCtx[3]})
	end;
	

	--Make vntext here
	vntext:make_actor("Dialogue Text", 700, STORYDATA.data and STORYDATA.data.TextSpeed or 50)..{
		InitCommand=cmd(xy,SCREEN_CENTER_X,0);
		StopCommand=cmd(visible,false);
		PlayCommand=cmd(visible,true);
	};
};

--Should only display when entering the screen for the first time.
--This is here because it needs to draw on top of the portraits...
t[#t+1]=LoadFont("Dialogue Text")..{
	Text="Press ESC or right click for options.";
	InitCommand=cmd(horizalign,left;vertalign,bottom;xy,5,SCREEN_BOTTOM-5;shadowlength,1;);
	OnCommand=cmd(sleep,10;linear,1;diffusealpha,0);
	PlayCommand=cmd(visible,true);
	
};

--This holds choices.
local cf = Def.ActorFrame{
	InitCommand=cmd(xy,SCREEN_RIGHT-200,SCREEN_CENTER_Y-50;diffusealpha,0);
	OnCommand=function(self)
		cursorFrame = self;
	end;
	TextboxAnimationFinishedMessageCommand=function(self)
		if ChoiceTable ~= nil and not ChoiceTable.Finished then
			--Warn("aaa "..table_print(ChoiceTable))
			assert(ChoiceTable.Choices)
			self:playcommand("Show");
		end;
	end;
	ShowCommand=function(self)
		--Warn("Fired!");
		--self:visible(true);
		self:diffusealpha(1);
		for i=1,6 do
			local a = self:GetChild(i);
			if i <= #ChoiceTable.Choices then
				a:GetChild("Text"):settext(ChoiceTable.Choices[i]);
				a:stoptweening():x(200):sleep((i-1)/8):decelerate(.2):x(0):diffusealpha(1);
				if i == 1 then
					a:playcommand("GainFocus");
				else
					a:addx(5):playcommand("LoseFocus");
				end;
			else
				a:diffusealpha(0);
			end;
		end;
		--self:playcommand("Update");
		--Reset cursor but no tween
		--self:GetChild("Cursor"):stoptweening():y(self:GetChild(ChoiceTable.Result):GetY())
	end;
	--[[HideCommand=function(self)
		self:diffusealpha(0);
	end;]]
	UpdateCommand=function(self)
		--self:GetChild("Cursor"):stoptweening():decelerate(.1):y(self:GetChild(ChoiceTable.Result):GetY());
		for i=1,6 do
			-- C++ is 0-indexed while lua is 1-indexed. So 0 is the minimum for an ActorScroller even though lua items start at 1.
			if ChoiceTable.Result == i then
				self:GetChild(i):playcommand("GainFocus")
			else
				self:GetChild(i):playcommand("LoseFocus")
			end;
		end;
		
	end;
};

local HEIGHT = 30;
for i=1,6 do
	cf[#cf+1] = Def.ActorFrame {
		Name=i;
		InitCommand=cmd(addy,i*50;diffusealpha,0);
	    --ShowCommand=cmd(stoptweening;x,200;sleep,(i-1)/8;decelerate,.2;x,0;diffusealpha,1);
	    HideCommand=cmd(stoptweening;sleep,(i-1)/8;decelerate,.2;x,200;diffusealpha,0);
	    GainFocusCommand=cmd(linear,.1;x,-5;);
		LoseFocusCommand=cmd(linear,.1;x,5;);
		Def.ActorFrame{
		
			--Text background
			Def.Quad{
				InitCommand=cmd(setsize,250,30;diffuse,color("0,0,0,.6");halign,0;faderight,.5);
			};
			
			--BG
			Def.Quad{
				InitCommand=cmd(setsize,220,8;horizalign,left;diffuse,Color("Black");vertalign,bottom;addy,HEIGHT/2);
				OnCommand=cmd(x,-5;addy,5);
			
			};
			parallelogramGen(HEIGHT,HEIGHT,Color("Black"))..{
				InitCommand=cmd(x,-5;addy,5;rotationy,180);
			};
			
			--FG
			Def.Quad{
				InitCommand=cmd(setsize,220,3;horizalign,left;vertalign,bottom;addy,HEIGHT/2);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			
			};
			parallelogramGen(HEIGHT,HEIGHT,Color("White"))..{
				InitCommand=cmd(rotationy,180);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			};
		};
		
		--Text
		LoadFont("Dialogue Text")..{
			Name="Text";
			Text=i;
			InitCommand=cmd(shadowcolor,Color("Black");shadowlength,1;x,100);
			GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
			LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
		};
		
	};
end;

t[#t+1]=cf

--===============================================
-- OPTIONS SCREEN IS HERE
--===============================================
local options = {
	{
		string="Continue",
		
	},
	{
		string="Skip To Next Cutscene",
		
	},
	{
		optionType='int',
		string="Text Speed",
		onLeftFunction=function(self)
			if vntext.spd > 10 then
				vntext.spd=vntext.spd-10;
				--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				return true;
			end;
		end,
		onRightFunction=function(self)
			if vntext.spd < 100 then
				vntext.spd=vntext.spd+10;
				--updateTextSpeed(self,vntext.spd);
				--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				return true; --Must return true for afterUpdateFunction to run.
			end;
		end,
		afterUpdateFunction=function(self)
			if STORYDATA.data and spd then
				STORYDATA.data.TextSpeed=spd;
			end;
			self:GetChild("Frame"..3):GetChild("Slider"):stoptweening():decelerate(.1):zoomtowidth(150*vntext.spd/100);
			self:GetChild("Frame"..3):GetChild("Value"):settext(vntext.spd == 100 and 'instant' or vntext.spd/10);
		end;
		
	},
	{
		optionType='bool',
		string="Auto Read",
		--valueKey=
	},
	{
		string="Save & Return to chapter select",
	},
	{
		string= "Save & Quit to main menu"
	}
}

local function updateFocus(self)
	--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
	for i=1, self:GetNumChildren() do
		if i == self:GetDestinationItem()+1 then
			self:GetChild("Frame"..i):playcommand("GainFocus");
		else
			self:GetChild("Frame"..i):playcommand("LoseFocus");
		end;
	end;
end;

--[[local function updateTextSpeed(self, spd)
	self:GetChild('Frame3'):GetChild("Text"):settextf(THEME:GetString("ScreenStoryOptions","Text Speed: %i"),vntext.spd/20)
end;]]

local oas = Def.ActorScroller{
	-- (float) Number of items to have visible at one time.
	-- ScrollThroughAllItems divides this value by 2.
	--NumItemsToDraw=0, -- Default value is 7 if this parameter is omitted.
	NumItemsToDraw=#options*2,

	-- (float) The number of seconds to show each item.
	SecondsPerItem=0, -- Default value is 1 if this parameter is omitted.

	-- Transforms the ActorScroller's children. Usually used for scrolling.
	-- The most important part of an ActorScroller.
	-- This example spaces each item out 32 pixels vertically.

	-- "offset" represents the offset from the center of the scroller.
	TransformFunction=function(self,offset,itemIndex,numItems)
		--self:x(300*offset)
		self:y(50*offset);
		--math.sin(offset*math.pi/2)
	end,
	
	SaveCommand=function(self)
		STORYDATA:SaveCurrentProgress()
	end;
	

	-- Scroller commands
	InitCommand=cmd(xy,25,200;SetFastCatchup,true;z,0),
	OnCommand=function(self)
		updateFocus(self);
		--set text speed
		options[3].afterUpdateFunction(self);
		SCREENMAN:GetTopScreen():AddInputCallback(function(event)
			if is_options_open==false then return end;
			
			local pn= event.PlayerNumber
			local button = event.button
			
			if not pn and event.DeviceInput.is_mouse == false then return end
			if event.type == "InputEventType_Release" then return end
			
			if event.DeviceInput.is_mouse then
				button = ToEnumShortString(event.DeviceInput.button)
			end
			
			if button == "Up" or button == "MenuUp" then
				if self:GetDestinationItem() > 0 then
					self:SetDestinationItem(self:GetDestinationItem()-1);
				updateFocus(self);
				end;
			elseif button == "Down" or button == "MenuDown" then
				if self:GetDestinationItem() < self:GetNumItems()-1 then
					self:SetDestinationItem(self:GetDestinationItem()+1);
				updateFocus(self);
				end;
				--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			elseif button == "Left" or button == "MenuLeft" then
				if options[self:GetDestinationItem()+1].onLeftFunction then
					if options[self:GetDestinationItem()+1].onLeftFunction(self) then
						options[self:GetDestinationItem()+1].afterUpdateFunction(self)
					end;
				end;
			elseif button == "Right" or button == "MenuRight" then
				if options[self:GetDestinationItem()+1].onRightFunction then
					if options[self:GetDestinationItem()+1].onRightFunction(self) then
						options[self:GetDestinationItem()+1].afterUpdateFunction(self)
					end;
				end;

			elseif button == "Start" then
				if self:GetDestinationItem() == 0 then
					MESSAGEMAN:Broadcast("OptionsScreenOff");
					is_options_open=false
					return true;
				elseif self:GetDestinationItem() == 4 then
					self:queuecommand("Save"); --To make saving seamless, do it the same time as the screen out
					SCREENMAN:GetTopScreen():SetNextScreenName(storyChapterSelect(false))
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
				elseif self:GetDestinationItem() == 5 then
					self:queuecommand("Save"); --To make saving seamless, do it the same time as the screen out
					SCREENMAN:GetTopScreen():SetNextScreenName(DebugOrRegularSelect(false))
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
				end;
			elseif button == "Back" then
				MESSAGEMAN:Broadcast("OptionsScreenOff");
				is_options_open=false
				return true;
			end;
		end);
	end;
	--[[CodeMessageCommand=
		function(self, param)
			if is_options_open ==false then return end;
			
			if param.Name == "Up" or param.Name == "MenuUp" then
				if self:GetDestinationItem() > 0 then
					self:SetDestinationItem(self:GetDestinationItem()-1);
				end;
				updateFocus(self);
			elseif param.Name == "Down" or param.Name == "MenuDown" then
				if self:GetDestinationItem() < self:GetNumItems()-1 then
					self:SetDestinationItem(self:GetDestinationItem()+1);
				end;
				updateFocus(self);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			elseif param.Name == "Left" or param.Name == "MenuLeft" then
				--SCREENMAN:SystemMessage(_G.selectedDifficulty);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			elseif param.Name == "Right" or param.Name == "MenuRight" then

				--SCREENMAN:SystemMessage(_G.selectedDifficulty);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			elseif param.Name == "Start" then
				if self:GetDestinationItem() == 0 then
					is_options_open=false
					return true;
				elseif self:GetDestinationItem() == 4 then
					MESSAGEMAN:Broadcast("VNQuit");
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
				end;
			end;
		end]]
	
}


-- children (items to scroll)
-- CAVEAT: BitmapTexts have to be wrapped in ActorFrames in order to be colored.
-- This is a long standing issue (ITG? ITG2?)
for i,option in ipairs(options) do
	local tmpFrame = Def.ActorFrame{
		Name="Frame"..i;
		Def.ActorMultiVertex{
			Name="Vertex";
			InitCommand=function(subself)
				subself:xy(-25,-20);
				subself:SetDrawState{Mode="DrawMode_QuadStrip"}
				--subself:ztest(true):ztestmode("ZTestMode_WriteOnFail");
			end;
			GainFocusCommand=function(q)
				q:stoptweening():SetVertices({
					{{0, 0, 0}, Color.HoloBlue},
					{{40, 0, 0}, Color.HoloBlue},
					{{0, 40, 0}, Color.HoloBlue},
					{{0, 40, 0}, Color.HoloBlue}
				})
				q:decelerate(.45):SetVertices({
					{{0, 0, 0}, Color.HoloBlue},
					{{400+40, 0, 0}, Color.HoloBlue},
					{{0, 40, 0}, Color.HoloBlue},
					{{400-2, 40, 0}, Color.HoloBlue}
				})
			end;
			LoseFocusCommand=function(q)
				q:finishtweening():SetVertices({
					{{0, 0, 0}, Color.HoloBlue},
					{{0, 0, 0}, Color.HoloBlue},
					{{0, 40, 0}, Color.HoloBlue},
					{{0, 40, 0}, Color.HoloBlue}
				})
			end;
		};
		Def.BitmapText{
			Name="Text";
			Font="Common Normal";
			Text=option.string;
			InitCommand=cmd(horizalign,left);
			GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color.Black);
			LoseFocusCommand=cmd(stoptweening;diffuse,color("ffffff"));
			--GainFocusCommand=cmd(stoptweening;linear,.1;zoom,1;diffuse,Color.Blue);
			--LoseFocusCommand=cmd(stoptweening;linear,.1;zoom,0.9;diffuse,color("ffffff"));
		}
	}
	if option.optionType then
			local clr = {.5,.5,.5,1};
			tmpFrame[#tmpFrame+1] = Def.ActorMultiVertex{
			Name="Vertex2";
			InitCommand=function(subself)
				subself:xy(200-50,-20);
				subself:SetDrawState{Mode="DrawMode_QuadStrip"}
				--subself:ztest(true):ztestmode("ZTestMode_WriteOnFail");
			end;
			GainFocusCommand=function(q)
				q:stoptweening():SetVertices({
					{{0, 0, 0}, clr},
					{{0, 0, 0}, clr},
					{{-40, 40, 0}, clr},
					{{-40, 40, 0}, clr}
				})
				q:sleep(.45/4):decelerate(.45*.7):SetVertices({
					{{0, 0, 0}, clr},
					{{200+40+25, 0, 0}, clr},
					{{-40, 40, 0}, clr},
					{{200-2+25, 40, 0}, clr}
				})
			end;
			LoseFocusCommand=function(q)
				q:finishtweening():SetVertices({
					{{0, 0, 0}, {0,0,0,.5}},
					{{0, 0, 0}, {0,0,0,.5}},
					{{0, 40, 0}, {0,0,0,.5}},
					{{0, 40, 0}, {0,0,0,.5}}
				})
			end;
		};
	
		if option.optionType == "int" then
			--[[tmpFrame[#tmpFrame+1] = rectGen(200,8,1,{.5,.5,.5,.5})..{
				InitCommand=cmd(x,225);
			};]]
			--[[tmpFrame[#tmpFrame+1]=Def.Quad{
				InitCommand=cmd(setsize,223,40;x,223+40;diffuse,Color.Red)
			}]]
			tmpFrame[#tmpFrame+1] = Def.Quad{
				Name="SliderBack";
				InitCommand=cmd(setsize,1,8;zoomtowidth,150;diffuse,Color.Black;horizalign,left;x,240-150/2);
				GainFocusCommand=cmd(stoptweening;sleep,.15;linear,.1;diffuse,Color.Black);
				LoseFocusCommand=cmd(stoptweening;diffuse,Color.White);
				
			}
			tmpFrame[#tmpFrame+1] = Def.Quad{
				Name="Slider";
				InitCommand=cmd(setsize,1,8;zoomtowidth,150;diffuse,Color.HoloBlue;horizalign,left;x,240-150/2)
			}
			tmpFrame[#tmpFrame+1] = Def.BitmapText{
				Font="Common Normal";
				Name='Value';
				Text='100';
				InitCommand=cmd(x,350;maxwidth,50);
			}
		else
			--[[tmpFrame[#tmpFrame+1]=Def.Quad{
				InitCommand=cmd(setsize,223,40;x,223+40;diffuse,Color.Red)
			}]]
			tmpFrame[#tmpFrame+1] = Def.BitmapText{
				Font="Common Normal";
				Text='OFF';
				Name='BoolOff';
				InitCommand=cmd(x,223+40-223/2+223*.25;diffuse,Color.White);
				--GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color.Black);
				GainFocusCommand=function(self)
					self:stoptweening():linear(.1):diffuse({0,0,0,self:GetDiffuseAlpha()});
				end;
				LoseFocusCommand=function(self)
					self:diffuse({1,1,1,self:GetDiffuseAlpha()});
				end;
			}
			
			tmpFrame[#tmpFrame+1] = Def.BitmapText{
				Font="Common Normal";
				Text='ON';
				Name='BoolOn';
				InitCommand=cmd(x,223+40-223/2+223*.75;diffuse,{1,1,1,.5});
				GainFocusCommand=function(self)
					self:stoptweening():linear(.1):diffuse({0,0,0,self:GetDiffuseAlpha()});
				end;
				LoseFocusCommand=function(self)
					self:diffuse({1,1,1,self:GetDiffuseAlpha()});
				end;
			}
		end;
	end;
	oas[#oas+1] = tmpFrame;
end;
t[#t+1] = Def.ActorFrame{
	OptionsScreenOnMessageCommand=cmd(visible,true);
	OptionsScreenOffMessageCommand=cmd(visible,false);
	InitCommand=cmd(visible,false);
	--[[Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH*1.5,SCREEN_HEIGHT;diffuse,color("0,0,0,0");faderight,1;Center);
		OptionsScreenOnMessageCommand=cmd(linear,.25;diffuse,color("0,0,0,.8"));
		OptionsScreenOffMessageCommand=cmd(stoptweening;diffuse,{0,0,0,0});
	};]]
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH*1.5,SCREEN_HEIGHT;diffuse,color("0,0,0,.7");cropright,1;Center);
		OptionsScreenOnMessageCommand=cmd(decelerate,.25;cropright,0);
		OptionsScreenOffMessageCommand=cmd(stoptweening;cropright,1);
	};
	LoadFont("Dialogue Text")..{
		Text="START or LEFT CLICK - Progress, LCTRL - Skip, UP/DOWN - Choices";
		InitCommand=cmd(horizalign,left;vertalign,bottom;xy,5,SCREEN_BOTTOM-5;shadowlength,1);
		PlayCommand=cmd(visible,true);
		
	};
	--[[Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,{0,0,0,.5};Center);
	};]]
	LoadFont("_ubuntu Italic 35px")..{
		Text="OPTIONS";
		InitCommand=cmd(horizalign,left;xy,20,25;zoom,1);
	};
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,1;xy,SCREEN_CENTER_X,50;faderight,1);
	};
	oas;
};

return t;
